package app.firezone.synk.network.Fragments;

import android.annotation.SuppressLint;
import android.app.AlertDialog;
import android.os.Bundle;

import androidx.fragment.app.Fragment;

import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.FirebaseDatabase;
import com.squareup.picasso.Picasso;

import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.API.SharedPrefManager;
import app.firezone.synk.network.R;
import app.firezone.synk.network.databinding.Fragment2Binding;
import app.firezone.synk.network.model.ApiResponse;
import app.firezone.synk.network.model.PaymentModel;
import app.firezone.synk.network.model.TransactionModel;
import app.firezone.synk.network.model.User;
import app.firezone.synk.network.model.UserResponse;
import app.firezone.synk.network.model.WithdrawModel;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;


public class Fragment2 extends Fragment {


    FirebaseUser auth;

    FirebaseDatabase database;
    DatabaseReference dr;

    Fragment2Binding binding;
    long minWithdraw, availWithdraw, inputUserCoins;
    private MyApi myApi;

    long userId;
    String email, username, phoneno;

    @SuppressLint("MissingInflatedId")
    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        binding = Fragment2Binding.inflate(inflater, container, false);
        View root = binding.getRoot();

        myApi = APIClient.getApiClient(getContext()).create(MyApi.class);

        userId = SharedPrefManager.getInstance(getContext()).getUserId(); // Get userId from SharedPreferences
        if (userId <= 0) {
            Toast.makeText(getContext(), "Invalid user ID", Toast.LENGTH_SHORT).show();
        }
        loadUserData();

        auth = FirebaseAuth.getInstance().getCurrentUser();
        database = FirebaseDatabase.getInstance();


        auth = FirebaseAuth.getInstance().getCurrentUser();

        setMinimumWithdrawal();

        if (availWithdraw <= minWithdraw){
            binding.withdrawBankBtn.setBackgroundResource(R.drawable.btn_true);
        }else {
            Toast.makeText(getContext(), "Minimum Withdraw "+minWithdraw+ "rs", Toast.LENGTH_SHORT).show();
            binding.withdrawBankBtn.setBackgroundResource(R.drawable.btn_false);
        }







        binding.withdrawBankBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                String amount = binding.withdrawBankAc.getText().toString();


                if (TextUtils.isEmpty(amount)) {
                    Toast.makeText(getContext(), "Enter Amount", Toast.LENGTH_SHORT).show();
                } else if (Integer.parseInt(binding.withdrawBankAc.getText().toString()) <= minWithdraw) {
                    binding.withdrawBankAc.setError("Minimum " + minWithdraw + "rs Withdraw");
                } else if (Long.parseLong(binding.withdrawBankAc.getText().toString()) >= availWithdraw) {
                    Toast.makeText(getContext(), "Not Enough Money", Toast.LENGTH_SHORT).show();
                } else {
                    inputUserCoins =  Long.parseLong(binding.withdrawBankAc.getText().toString());
                    withdrawMoney();
                }
            }
        });





        return  root;
    }

    private void loadUserData() {

        MyApi myApi = APIClient.getApiClient(getContext()).create(MyApi.class);
        Call<ApiResponse> call = myApi.fetchProfileData(userId);

        call.enqueue(new Callback<ApiResponse>() {
            @Override
            public void onResponse(Call<ApiResponse> call, Response<ApiResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    User model = response.body().getUser();

                    long totalWinBal  = model.getWinBalance();
                    long totalDepoBal  = model.getDepoBalance();

                    availWithdraw = model.getWinBalance();

                    email = model.getEmail();
                    username = model.getName();

                    String totalBal = String.valueOf(totalWinBal);

                    binding.totalBalances.setText(totalBal);
                    binding.name.setText(model.getName());

                    Picasso.get()
                            .load(model.getProfile())
                            .placeholder(R.drawable.new_users)
                            .into(binding.imageView15);

                    email = model.getEmail();
                    phoneno = model.getPhoneno();
                } else {
                    Toast.makeText(getContext(), "Failed to fetch user data", Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<ApiResponse> call, Throwable throwable) {

            }
        });
    }


    private void withdrawMoney() {

        AlertDialog.Builder builder = new AlertDialog.Builder(getContext());
        View mView = getLayoutInflater().inflate(R.layout.bankaccount_layout, null);

        final EditText bankname = (EditText) mView.findViewById(R.id.bankName);
        final EditText accountno = (EditText) mView.findViewById(R.id.accountNo);
        final EditText accountnocnfm = (EditText) mView.findViewById(R.id.accountNoCnfm);
        final EditText holdername = (EditText) mView.findViewById(R.id.accounHolderName);
        final EditText ifsccode = (EditText) mView.findViewById(R.id.ifscCode);
        final TextView amount = (TextView) mView.findViewById(R.id.bankAmnt);
        Button bankWithdrawBtn = (Button) mView.findViewById(R.id.submitButton);


        amount.setText(binding.withdrawBankAc.getText().toString());

        builder.setView(mView);
        AlertDialog alertDialogs = builder.create();

        bankWithdrawBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                String bankName = bankname.getText().toString();
                String accountNo = accountno.getText().toString();
                String accountNoCnfm = accountnocnfm.getText().toString();
                String holderName = holdername.getText().toString();
                String ifscCode = ifsccode.getText().toString();


                if (TextUtils.isEmpty(bankName)){
                    bankname.setError("Your Bank Name");
                    Toast.makeText(getContext(), "Enter Your Bank Name", Toast.LENGTH_SHORT).show();
                    return;
                }

                if (TextUtils.isEmpty(accountNo)){
                    accountno.setError("Account No.");
                    Toast.makeText(getContext(), "Enter Your Account No.", Toast.LENGTH_SHORT).show();
                    return;
                }

                if (TextUtils.isEmpty(accountNoCnfm)){
                    Toast.makeText(getContext(), "Re-enter Account No.", Toast.LENGTH_SHORT).show();
                    accountnocnfm.setError("Re-enter Account no");
                    return;
                }

                if (TextUtils.isEmpty(holderName)){
                    Toast.makeText(getContext(), "Enter Account Holder Name", Toast.LENGTH_SHORT).show();
                    holdername.setError("Enter Account Holder Name");
                    return;
                }

                if (TextUtils.isEmpty(ifscCode)){
                    Toast.makeText(getContext(), "Enter Your IFSC Code", Toast.LENGTH_SHORT).show();
                    ifsccode.setError("Enter IFSC Code");

                }else {

                    String withdrawCoins =  String.valueOf(inputUserCoins);

                    String banknames = bankname.getText().toString();
                    String accountNos = accountno.getText().toString();
                    String accountNoCnfms = accountnocnfm.getText().toString();
                    String holderNames = holdername.getText().toString();
                    String ifscCodes = ifsccode.getText().toString();

                    String status  =  "Pending";
                    String method  =  "BANK";

                    Calendar calForDate= Calendar.getInstance();
                    SimpleDateFormat currentDate= new SimpleDateFormat("dd-MM-yy");
                    String date= currentDate.format(calForDate.getTime());

                    // Example data to store
                    myApi = APIClient.getApiClient(getContext()).create(MyApi.class);
                    Call<WithdrawModel> call = myApi.storeWithdraw(
                            String.valueOf(userId),
                            withdrawCoins,
                            username,
                            email,
                            phoneno,
                            date,
                            "N/A",
                            banknames,
                            accountNos,
                            ifscCodes,
                            holderNames,
                            status,
                            method
                    );

                    call.enqueue(new Callback<WithdrawModel>() {
                        @Override
                        public void onResponse(Call<WithdrawModel> call, Response<WithdrawModel> response) {
                            if (response.isSuccessful() && response.body() != null) {
                                Toast.makeText(getContext(), "Withdraw request submitted successfully!", Toast.LENGTH_SHORT).show();
                                alertDialogs.dismiss();
                                binding.withdrawBankAc.setText("");
                                deductedMoney();
                            } else {
                                Toast.makeText(getContext(), "Failed to submit request: " + response.message(), Toast.LENGTH_LONG).show();
                            }
                        }

                        @Override
                        public void onFailure(Call<WithdrawModel> call, Throwable t) {
                            Toast.makeText(getContext(), "Error: " + t.getMessage(), Toast.LENGTH_LONG).show();
                        }
                    });
                }

            }
        });

        alertDialogs.show();

    }


    private void setMinimumWithdrawal() {

        MyApi myApi = APIClient.getApiClient(getContext()).create(MyApi.class);
        Call<ArrayList<PaymentModel>> call = myApi.fetchPaymentSetting();

        call.enqueue(new Callback<ArrayList<PaymentModel>>() {
            @Override
            public void onResponse(Call<ArrayList<PaymentModel>> call, Response<ArrayList<PaymentModel>> response) {

                if (response.isSuccessful() && response.body() != null && !response.body().isEmpty()) {
                    PaymentModel model = response.body().get(0); // Assuming you need the first payment setting

                    minWithdraw = model.getMinWithdraw();
                } else {
                    Toast.makeText(getContext(), "Failed to fetch payment settings", Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<ArrayList<PaymentModel>> call, Throwable throwable) {
                Toast.makeText(getContext(), "Error: " + throwable.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });
    }

    private  void deductedMoney(){

        long finalCoins =  availWithdraw - inputUserCoins;

        Map<String, Object> updateData = new HashMap<>();
        updateData.put("winBalance",finalCoins);

        MyApi myApi = APIClient.getApiClient(getContext()).create(MyApi.class);

        // API Call to update the user's wallet balance
        Call<UserResponse> call = myApi.updateUser(userId, updateData);
        call.enqueue(new Callback<UserResponse>() {
            @Override
            public void onResponse(Call<UserResponse> call, Response<UserResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    if (response.body().isSuccess()) {
                        saveUsersTransactionDetails();
                        Toast.makeText(getContext(), "Amount Debited...", Toast.LENGTH_SHORT).show();
                        loadUserData();
                    } else {
                        Toast.makeText(getContext(), response.body().getMessage(), Toast.LENGTH_SHORT).show();
                    }
                } else {
                    Toast.makeText(getContext(), "Failed to update balance", Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<UserResponse> call, Throwable throwable) {
                Toast.makeText(getContext(), "Error: " + throwable.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });
    }

    private void saveUsersTransactionDetails() {
        // Get user details
        long userIdLong = SharedPrefManager.getInstance(getContext()).getUserId();
        String userId = String.valueOf(userIdLong); // Convert to String for API call
        String date = new SimpleDateFormat("dd-MM-yy", Locale.getDefault()).format(Calendar.getInstance().getTime());
        String time = new SimpleDateFormat("HH:mm:ss", Locale.getDefault()).format(Calendar.getInstance().getTime());
        String transactionId = "TRAN" + System.currentTimeMillis();
        String inputCoin = String.valueOf(inputUserCoins);

        // Initialize API Client
        MyApi myApi = APIClient.getApiClient(getContext()).create(MyApi.class);

        Call<TransactionModel> call = myApi.storeUserTransaction(
                userId,
                "Withdraw", // type
                email,
                inputCoin, // amount
                date,
                time,
                transactionId,
                "Wallet", // method
                "Pending" // status
        );

        call.enqueue(new Callback<TransactionModel>() {
            @Override
            public void onResponse(Call<TransactionModel> call, Response<TransactionModel> response) {
                if (response.isSuccessful() && response.body() != null) {
                    Toast.makeText(getContext(), "Transaction Recorded Successfully", Toast.LENGTH_SHORT).show();
                } else {
                    Toast.makeText(getContext(), "Failed to Record Transaction: " + response.message(), Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<TransactionModel> call, Throwable throwable) {
                Toast.makeText(getContext(), "Error: " + throwable.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });
    }

}
